/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequest;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResult;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.sas.CredentialCompletionStatus;
import com.ibm.hwmca.base.rsf.sas.CredentialResult;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.RbfResult;
import com.ibm.hwmca.fw.rbf.RbfResultProcessor;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.net.InetAddress;
import java.util.HashMap;

public class BaseRsfResultProcessor
implements RbfResultProcessor,
BaseRsfRequestErrorIds {
    private static String TRACE_MASKF = "XRSFRSPF";
    private static String TRACE_MASKT = "XRSFRSPT";
    private static String TRACE_MASKD = "XRSFRSPD";
    private static HashMap statusCodeMappings = new HashMap();
    private static HashMap rsfStatusMsgs = new HashMap();
    private static HashMap rbfStatusMsgs = new HashMap();
    private static final short SUCCESSFUL_EVENT = 674;
    private static final short CANCELED_EVENT = 675;
    private static final short FAILURE_EVENT = 679;
    private static final short INTERNAL_ERROR_EVENT = 676;
    private static final short DEFAULT_FAILURE_EVENT = 676;
    private static final String SUCCESSFUL_EVENT_NAME = "TRSF_COMP";
    private static final String CANCELED_EVENT_NAME = "TRSF_CANCEL";
    private static final String UNSUCCESSFUL_EVENT_NAME = "TRSF_FAIL";
    private static final int[] externalReasonCode = new int[]{0, 1, 1, 3, 1, 5, 1, 7, 1, 9};
    private static int CREDENTIAL_RETRIES = 1;
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(94, "RsfResult");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static FrameworkLogAttributes infoLogDisplayError = new FrameworkLogAttributes(false, false, true, true, true, true, false, 0);
    private static BaseRemoteSupportFacility baseRsf = BaseRemoteSupportFacility.getBaseRsf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean redriveCredentialFailure(int rsfReasonCode, RbfRequest rbfRequest) {
        Trace.trace(TRACE_MASKT, "-> BaseRsfResultProcessor::redriveCredentialFailure() reason code=" + rsfReasonCode);
        BaseRsfRequestImpl newRequest = ((BaseRsfRequestImpl)rbfRequest).copyRequest();
        if (rsfReasonCode == 13 || rsfReasonCode == 15) {
            CredentialResult result;
            Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor.redriveCredentialFailure: getting new credentials");
            BaseRsfRequest rsfRequest = ((BaseRsfRequestImpl)rbfRequest).getRsfRequest();
            RsfRequestBody requestBody = rsfRequest.getBody();
            if (requestBody.isConsoleRequest() || !(requestBody instanceof XFrameRsfRequestBody)) {
                Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor.redriveCredentialFailure: getting new local credentials");
                CredentialUtils.clearLocalCredentials();
                result = CredentialUtils.getNewLocalCredentialsSynchronous();
            } else {
                Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor.redriveCredentialFailure: getting new non-local credentials");
                RsfMachineInfo machInfo = ((XFrameRsfRequestBody)requestBody).getReportingMachineInfo();
                String target = machInfo.getMachineType() + machInfo.getMachineSerial();
                try {
                    result = CredentialUtils.getNewCredentialsSynchronous(target, BaseRsfRequest.getCredentialStoreImpl(rbfRequest.getType()));
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "redriveCredentialFailure: exception getting credentials:");
                    Trace.trace(TRACE_MASKF, e);
                    Trace.trace(TRACE_MASKT, "<- BaseRsfResultProcessor::redriveCredentialFailure() false");
                    return false;
                }
            }
            CredentialCompletionStatus credStatus = result.getStatus();
            Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor.redriveCredentialFailure: new credential status=" + credStatus);
            if (credStatus != CredentialCompletionStatus.SUCCESS) {
                Trace.trace(TRACE_MASKT, "<- BaseRsfResultProcessor::redriveCredentialFailure() false");
                return false;
            }
            newRequest.setOwningCredentials(result.getCredentials());
        }
        BaseRemoteSupportFacility baseRemoteSupportFacility = baseRsf;
        synchronized (baseRemoteSupportFacility) {
            baseRsf.addRequest(newRequest.getId(), newRequest.getIdentifier());
            newRequest.getRsfRequest().request = newRequest;
        }
        Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor: redriveCredentialFailure: Rsf Request '" + newRequest.getId() + "' mapped to new Rbf request id '" + newRequest.getIdentifier() + "'");
        try {
            newRequest.submit();
        }
        catch (Exception e) {
            BaseRsfResultProcessor.logError("BaseRsfResultProcessor.redriveCredentialFailure: error resubmitting request:", e, (short)12554);
            return false;
        }
        baseRsf.requestChanged(3, newRequest.getRsfRequest());
        baseRsf.requestChanged(0, newRequest.getRsfRequest());
        Trace.trace(TRACE_MASKT, "<- BaseRsfResultProcessor::redriveCredentialFailure() true");
        return true;
    }

    public void rbfResultAvailable(RbfRequest rbfRequest, RbfResult rbfResult) {
        String eventName;
        short eventId;
        String rsfStatusMsg;
        Trace.trace(TRACE_MASKT, "-> rbfResultAvailable()");
        BaseRsfRequestImpl baseRequest = (BaseRsfRequestImpl)rbfRequest;
        int rbfStatusCode = rbfResult.getStatusCode();
        Integer mappedStatusCode = (Integer)statusCodeMappings.get(new Integer(rbfStatusCode));
        int statusCode = mappedStatusCode != null ? mappedStatusCode : 5;
        Trace.trace(TRACE_MASKD, "rbf status= " + rbfStatusCode + " rsf status=" + statusCode);
        String rbfStatusMsg = (String)rbfStatusMsgs.get(new Integer(rbfStatusCode));
        if (rbfStatusMsg == null) {
            rbfStatusMsg = "Unknown";
        }
        if ((rsfStatusMsg = (String)rsfStatusMsgs.get(new Integer(statusCode))) == null) {
            rsfStatusMsg = "Unknown";
        }
        BaseRsfResultProcessor.logInfo("RsfResultAvailable processing for request " + baseRequest.getId() + ".\nRbf status= " + rbfStatusMsg + "\nRsf status= " + rsfStatusMsg, null, (short)12553);
        BaseRsfRequest rsfRequest = baseRequest.getRsfRequest();
        baseRsf.requestChanged(2, rsfRequest);
        String requestId = baseRequest.getIdentifier().toString();
        RsfResultDetails rsfDetails = null;
        Object details = rbfResult.getDetails();
        short statusMessageCode = 676;
        int rsfReasonCode = 0;
        LocalizableText reasonCodeMsg = null;
        if (statusCode == 1) {
            if (baseRequest.getOwningCredentials() != null) {
                BaseRemoteSupportFacility.consecutiveCredentialFailures = 0;
            }
            if (details == null || !(details instanceof BaseRsfResultDetails)) {
                BaseRsfResultProcessor.logError("BaseRsfResultProcessor.rbfResultAvailable: unexpected null BaseRsfResultDetails with RESULT_OK", null, (short)12547);
            } else {
                rsfDetails = ((BaseRsfResultDetails)details).getRsfResultDetails();
                rsfReasonCode = ((BaseRsfResultDetails)details).getReasonCode();
                reasonCodeMsg = ((BaseRsfResultDetails)details).getReasonCodeMessage();
            }
        }
        BaseRsfResult result = new BaseRsfResult(rsfDetails, statusCode, rsfRequest);
        if (statusCode == 2) {
            statusMessageCode = 679;
            if (details == null || !(details instanceof BaseRsfResultDetails)) {
                BaseRsfResultProcessor.logError("BaseRsfResultProcessor.rbfResultAvailable: unexpected null BaseRsfResultDetails with RESULT_FAILED", null, (short)12547);
            } else {
                rsfReasonCode = ((BaseRsfResultDetails)details).getReasonCode();
                if (((BaseRsfRequestImpl)rbfRequest).incrementCredentialTries() <= BaseRsfRequest.CREDENTIAL_TRIES && (rsfReasonCode == 10 || rsfReasonCode == 11 || rsfReasonCode == 13 || rsfReasonCode == 14 || rsfReasonCode == 17 || rsfReasonCode == 18 || rsfReasonCode == 15 || rsfReasonCode == 16) && this.redriveCredentialFailure(rsfReasonCode, rbfRequest)) {
                    return;
                }
                reasonCodeMsg = ((BaseRsfResultDetails)details).getReasonCodeMessage();
                result.setDetails(((BaseRsfResultDetails)details).getRsfResultDetails());
                Trace.trace(TRACE_MASKD, "reason code= " + rsfReasonCode);
                String logMsg = ((BaseRsfResultDetails)details).getErrLogMsg();
                if (logMsg != null) {
                    Trace.trace(TRACE_MASKF, "error logged at target: " + logMsg);
                    BaseRsfResultProcessor.logError("RsfResultProcessor: error found at call home server: " + logMsg, null, (short)12547);
                }
            }
        }
        if (rsfReasonCode >= 0 && rsfReasonCode < externalReasonCode.length) {
            result.setReasonCode(externalReasonCode[rsfReasonCode]);
        } else {
            result.setReasonCode(rsfReasonCode);
        }
        if (statusCode == 4) {
            try {
                RbfErrorDetail rbfDetails = (RbfErrorDetail)details;
                BaseRsfResultProcessor.logError("Rbf internal error-reason code=" + rbfDetails.getReasonCode() + " with details:" + rbfDetails.getDiagnostic(), null, (short)12547);
            }
            catch (Exception e) {
                BaseRsfResultProcessor.logError("Unable to obtain RbfErrorDetail when rbf status=" + rbfStatusCode + ". Exception: ", e, (short)12547);
            }
        }
        if (statusCode == 3) {
            if (details == null || !(details instanceof BaseRsfResultDetails)) {
                Trace.trace(TRACE_MASKF, "unexpected null BaseRsfResultDetails with RESULT_INVALID_REQUEST");
                new FrameworkLog(logInfo, 12547).log(infoLogDisplayError);
            } else {
                RsfResultDetails resultParms = ((BaseRsfResultDetails)details).getRsfResultDetails();
                String failureMessage = (String)resultParms.getAttribute("error message");
                FrameworkLog fl = new FrameworkLog(logInfo, 12547);
                if (failureMessage != null) {
                    fl.add("BaseRsfResultProcessor.rbfResultAvailable(): invalid request:/n" + failureMessage);
                } else {
                    fl.add("BaseRsfResultProcessor.rbfResultAvailable(): invalid request with no error message");
                }
                fl.log(infoLogDisplayError);
            }
        }
        RbfRequestType reqType = baseRequest.getType();
        if (statusCode == 6 || statusCode == 7) {
            eventId = 675;
            eventName = CANCELED_EVENT_NAME;
            statusMessageCode = 675;
        } else if (statusCode == 1) {
            eventId = 674;
            eventName = SUCCESSFUL_EVENT_NAME;
            statusMessageCode = 674;
        } else if (statusCode == 2 && rsfReasonCode < BaseRsfResultDetails.eventCodes.length) {
            eventId = BaseRsfResultDetails.eventCodes[rsfReasonCode];
            eventName = UNSUCCESSFUL_EVENT_NAME;
            statusMessageCode = eventId;
        } else {
            eventId = 676;
            eventName = UNSUCCESSFUL_EVENT_NAME;
        }
        String[] substParms = new String[]{"", baseRequest.getOriginMachine().getName()};
        MachineId machine = baseRequest.getHandlingMachine();
        if (machine == null) {
            substParms[0] = "not assigned";
        } else {
            InetAddress[] address = machine.getNicAddresses();
            substParms[0] = machine.getName() + "(" + address[0].getHostAddress() + ")";
        }
        FrameworkEventText eventText = new FrameworkEventText(eventId, substParms);
        if (reasonCodeMsg != null) {
            result.setReasonCodeMessage(reasonCodeMsg);
        } else {
            result.setReasonCodeMessage(eventText);
        }
        Trace.trace(TRACE_MASKF, "rsfReasonCode " + result.getReasonCode() + " and reason code message= " + result.getReasonMessage());
        result.setStatusMessage(new FrameworkEventText(statusMessageCode, substParms));
        new SystemEventLog(eventText, eventName).log();
        String resultProcessor = baseRequest.getRsfResultProcessor();
        Class<?> resultProcessorClass = null;
        try {
            resultProcessorClass = Class.forName(resultProcessor);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Result processor class " + resultProcessorClass + " not found");
            new FrameworkLog(logInfo, 12547, e).log(infoLogDisplayError);
        }
        rsfRequest.setReporting(true);
        if (resultProcessorClass != null) {
            try {
                ((RsfResultProcessor)resultProcessorClass.newInstance()).rsfRequestCompleted(rsfRequest, result);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception calling given ResourceResultProcessor -" + resultProcessorClass.getName());
                Trace.trace(TRACE_MASKF, e);
                new FrameworkLog(logInfo, 12547, e).log(infoLogDisplayError);
            }
        }
        if (BaseRemoteSupportFacility.testRQ) {
            Trace.trace(TRACE_MASKF, "about to execute test wait");
            try {
                Thread.sleep(BaseRemoteSupportFacility.testWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "finished executing test wait");
        }
        baseRsf.requestChanged(3, rsfRequest);
        Trace.trace(TRACE_MASKF, "BaseRsfResultProcessor.rbfResultAvailable removing request " + requestId);
        baseRsf.removeRequest(requestId);
        Trace.trace(TRACE_MASKT, "<- rbfResultAvailable()");
    }

    private static void logInfo(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private static void logError(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    static {
        Trace.trace(TRACE_MASKT, "-> static Initializer");
        statusCodeMappings.put(new Integer(0), new Integer(1));
        statusCodeMappings.put(new Integer(4), new Integer(4));
        statusCodeMappings.put(new Integer(24), new Integer(3));
        statusCodeMappings.put(new Integer(8), new Integer(4));
        statusCodeMappings.put(new Integer(12), new Integer(4));
        statusCodeMappings.put(new Integer(16), new Integer(5));
        statusCodeMappings.put(new Integer(20), new Integer(5));
        statusCodeMappings.put(new Integer(32), new Integer(5));
        statusCodeMappings.put(new Integer(28), new Integer(2));
        statusCodeMappings.put(new Integer(36), new Integer(6));
        statusCodeMappings.put(new Integer(40), new Integer(7));
        statusCodeMappings.put(new Integer(44), new Integer(7));
        rsfStatusMsgs.put(new Integer(1), new String("Successful"));
        rsfStatusMsgs.put(new Integer(3), new String("Request Invalid"));
        rsfStatusMsgs.put(new Integer(4), new String("Internal Error"));
        rsfStatusMsgs.put(new Integer(2), new String("Request handling failure"));
        rsfStatusMsgs.put(new Integer(6), new String("Canceled by submitter (Remote support Queue)"));
        rsfStatusMsgs.put(new Integer(5), new String("Rsf not capable of processing this request"));
        rsfStatusMsgs.put(new Integer(7), new String("Canceled by user (Remote connection queue)"));
        rbfStatusMsgs.put(new Integer(0), new String("Request successful"));
        rbfStatusMsgs.put(new Integer(4), new String("Request Invalid"));
        rbfStatusMsgs.put(new Integer(24), new String("Handler-detected Request Invalid"));
        rbfStatusMsgs.put(new Integer(8), new String("Internal Error"));
        rbfStatusMsgs.put(new Integer(12), new String("Application Error"));
        rbfStatusMsgs.put(new Integer(16), new String("Hander unavailable"));
        rbfStatusMsgs.put(new Integer(20), new String("Handler not capable for this request"));
        rbfStatusMsgs.put(new Integer(32), new String("Handler outage"));
        rbfStatusMsgs.put(new Integer(28), new String("Handler failure"));
        rbfStatusMsgs.put(new Integer(36), new String("Canceled by submitter"));
        rbfStatusMsgs.put(new Integer(40), new String("Canceled - not handled"));
        rbfStatusMsgs.put(new Integer(44), new String("Canceled at handler"));
        Trace.trace(TRACE_MASKT, "-> static Initializer");
    }
}

